/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.stateless.StatelessGeoBlockEntity;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.network.AbstractPacket;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.NetworkUtil;

public class StatelessBlockEntityPlayAnimPacket
extends AbstractPacket {
    private final class_2338 blockPos;
    private final RawAnimation animation;

    public StatelessBlockEntityPlayAnimPacket(class_2338 blockPos, RawAnimation animation) {
        this.blockPos = blockPos;
        this.animation = animation;
    }

    @Override
    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(this.blockPos);
        NetworkUtil.writeRawAnimationToBuffer(this.animation, buf);
        return buf;
    }

    @Override
    public class_2960 getPacketID() {
        return GeckoLibNetwork.STATELESS_BLOCK_ENTITY_PLAY_ANIM_PACKET_ID;
    }

    public static void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        class_2338 blockPos = buf.method_10811();
        RawAnimation animation = NetworkUtil.readRawAnimationFromBuffer(buf);
        client.execute(() -> StatelessBlockEntityPlayAnimPacket.runOnThread(blockPos, animation));
    }

    private static <D> void runOnThread(class_2338 blockPos, RawAnimation animation) {
        GeoBlockEntity blockEntity;
        class_2586 class_25862 = ClientUtils.getLevel().method_8321(blockPos);
        if (class_25862 instanceof GeoBlockEntity && (blockEntity = (GeoBlockEntity)class_25862) instanceof StatelessGeoBlockEntity) {
            StatelessGeoBlockEntity statelessAnimatable = (StatelessGeoBlockEntity)blockEntity;
            statelessAnimatable.handleClientAnimationPlay(blockEntity, 0L, animation);
        }
    }
}

